/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.runtime.summary;

import filenet.vw.toolkit.runtime.VWTrkDataModel;
import filenet.vw.toolkit.runtime.VWTrkMilestone;
import filenet.vw.toolkit.runtime.summary.VWMilestoneHistoryTable;
import filenet.vw.toolkit.runtime.summary.VWMilestoneHistoryTableModel;
import filenet.vw.toolkit.runtime.summary.VWTrackerSummaryInfo;
import filenet.vw.toolkit.runtime.summary.resources.VWResource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class VWMilestoneHistoryPanel
extends JPanel
implements MouseListener {
    private VWMilestoneHistoryTableModel m_tableModel = null;
    private VWMilestoneHistoryTable m_table = null;
    private VWTrkDataModel m_trackerDataModel = null;
    private JComboBox m_levelCombo = null;
    private ItemListener m_levelComboItemListener = null;
    private DefaultComboBoxModel m_levelComboModel = null;
    private Frame m_parentFrame = null;
    private VWTrackerSummaryInfo m_summaryPanel = null;

    VWMilestoneHistoryPanel(Frame parentFrame, VWTrackerSummaryInfo summaryPanel, VWTrkDataModel trackerDataModel) {
        this.m_parentFrame = parentFrame;
        this.m_summaryPanel = summaryPanel;
        this.m_trackerDataModel = trackerDataModel;
        this.setupLayout();
    }

    public void initialize() {
        if (this.m_trackerDataModel == null || this.m_trackerDataModel.getInitState() != 6) {
            return;
        }
        this.initLevelCombo();
    }

    private void setupLayout() {
        this.setLayout(new BorderLayout());
        this.m_levelComboModel = new DefaultComboBoxModel();
        this.m_levelCombo = new JComboBox(this.m_levelComboModel);
        this.m_tableModel = new VWMilestoneHistoryTableModel(this.m_trackerDataModel);
        this.m_table = new VWMilestoneHistoryTable(this.m_parentFrame, this.m_summaryPanel, this.m_tableModel);
        this.m_table.addMouseListener(this);
        JPanel topPanel = new JPanel();
        JPanel levelPanel = new JPanel();
        levelPanel.setLayout(new BoxLayout(levelPanel, 2));
        topPanel.setLayout(new BorderLayout());
        levelPanel.add(new JLabel(VWResource.s_showMilestoneLevelsUpTo));
        levelPanel.add(Box.createHorizontalStrut(10));
        levelPanel.add(this.m_levelCombo);
        topPanel.add((Component)levelPanel, "Before");
        this.add((Component)topPanel, "First");
        this.add((Component)new JScrollPane(this.m_table), "Center");
        this.m_levelComboItemListener = new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                Object obj;
                if (e.getStateChange() == 1 && (obj = VWMilestoneHistoryPanel.this.m_levelCombo.getSelectedItem()) != null && obj instanceof Integer) {
                    VWMilestoneHistoryPanel.this.m_tableModel.setMaxLevelShown((Integer)obj);
                }
            }
        };
        this.m_levelCombo.addItemListener(this.m_levelComboItemListener);
    }

    private Integer[] getMilestoneLevels() {
        if (this.m_trackerDataModel == null || this.m_trackerDataModel.getInitState() != 6) {
            return null;
        }
        int size = 20;
        int maxLevel = 0;
        int levelCount = 0;
        Integer[] array = new Integer[size];
        Vector milestones = null;
        if (this.m_tableModel != null) {
            milestones = this.m_tableModel.getMilestones();
        } else {
            this.m_trackerDataModel.getMilestones();
        }
        if (milestones != null) {
            for (int i = 0; i < milestones.size(); ++i) {
                Object obj = milestones.elementAt(i);
                if (obj == null || !(obj instanceof VWTrkMilestone)) continue;
                int level = ((VWTrkMilestone)obj).getLevel();
                if (level >= size) {
                    Integer[] newArray = new Integer[level + 10];
                    System.arraycopy(array, 0, newArray, 0, size);
                    array = newArray;
                    size = level + 10;
                }
                if (array[level] == null) {
                    array[level] = new Integer(level);
                    ++levelCount;
                }
                if (level <= maxLevel) continue;
                maxLevel = level;
            }
        }
        Integer[] levels = new Integer[levelCount];
        int index = 0;
        for (int i = 0; i <= maxLevel; ++i) {
            if (array[i] == null) continue;
            levels[index++] = array[i];
            if (index >= levelCount) break;
        }
        return levels;
    }

    private void initLevelCombo() {
        if (this.m_levelCombo != null) {
            if (this.m_levelComboModel == null) {
                this.m_levelComboModel = new DefaultComboBoxModel();
                this.m_levelCombo.setModel(this.m_levelComboModel);
            } else {
                this.m_levelComboModel.removeAllElements();
            }
            Integer[] levels = this.getMilestoneLevels();
            for (int i = 0; i < levels.length; ++i) {
                this.m_levelComboModel.addElement(levels[i]);
            }
        }
    }

    public void mouseClicked(MouseEvent evt) {
        Object source = evt.getSource();
        if (!(source instanceof JTable) || source != this.m_table) {
            return;
        }
        Point point = evt.getPoint();
        int row = this.m_table.rowAtPoint(point);
        int col = this.m_table.columnAtPoint(point);
        if (col == 1) {
            this.m_tableModel.toggleShowDetails(row);
            this.m_table.setRowSelectionInterval(row, row);
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void removeReferences() {
        this.m_trackerDataModel = null;
        if (this.m_tableModel != null) {
            this.m_tableModel.removeReferences();
            this.m_tableModel = null;
        }
        if (this.m_table != null) {
            this.m_table.removeMouseListener(this);
            this.m_table.removeReferences();
            this.m_table = null;
        }
        if (this.m_levelCombo != null) {
            this.m_levelCombo.removeItemListener(this.m_levelComboItemListener);
            this.m_levelCombo.removeAllItems();
            this.m_levelCombo = null;
        }
        this.m_levelComboItemListener = null;
        if (this.m_levelComboModel != null) {
            this.m_levelComboModel.removeAllElements();
            this.m_levelComboModel = null;
        }
        this.removeAll();
    }
}

